Attribute VB_Name = "MdlGraph"
Option Explicit

Const GRAPH_Y_POSI_OFFSET As Single = 0.8
Const CENTER_OFFSET As Single = 50
Const GRAPH_Y_RATIO As Single = 1.054545

Public Const pi As Double = 3.14159265358979
Public Const COLOR_DARKSLATEGRAY As Long = 5197615  ' RGB(&H2F, &H4F, &H4F)
Public Const COLOR_SALMON As Long = 7504122         ' RGB(&HFA, &H80, &H72)
Public Const COLOR_GRAY As Long = 8421504           ' RGB(&H80, &H80, &H80)
Public Const COLOR_DODGERBLUE As Long = 16748574    ' RGB(&H1E, &H90,&HFF)
Public Const COLOR_DEEPPINK As Long = 9639167       ' RGB(&HFF, &H14, &H93)
Public Const COLOR_ORANGEREAD As Long = 42495       ' RGB(&HFF, &HA5, &H00)
Public Const COLOR_GRID_LOGMAG As Long = COLOR_DARKSLATEGRAY
Public Const COLOR_BOLD_GRID_LOGMAG As Long = COLOR_GRAY
Public Const COLOR_WAVE_LOGMAG As Long = vbYellow
Public Const COLOR_REFL_LOGMAG As Long = COLOR_WAVE_LOGMAG

Public Const COLOR_WAVE_PHASE As Long = vbGreen
Public Const COLOR_REFL_PHASE As Long = COLOR_WAVE_PHASE

Public Const COLOR_MARK_POLAR_SMITH As Long = vbRed

Public Const COLOR_WAVE_POLAR As Long = COLOR_SALMON
Public Const COLOR_GRID_POLAR As Long = vbWhite
Public Const COLOR_BOLD_GRID_POLAR As Long = COLOR_DARKSLATEGRAY

Public Const COLOR_WAVE_SMITH As Long = COLOR_DODGERBLUE
Public Const COLOR_GRID_SMITH As Long = COLOR_GRAY
Public Const COLOR_BOLD_GRID_SMITH As Long = vbWhite

Public Const COLOR_WAVE_DELAY As Long = COLOR_DEEPPINK
Public Const COLOR_REFL_DELAY As Long = COLOR_WAVE_DELAY
Public Const COLOR_GRID_DELAY As Long = COLOR_DARKSLATEGRAY
Public Const COLOR_BOLD_GRID_DELAY As Long = COLOR_GRAY

Public Const COLOR_WAVE___SWR As Long = COLOR_ORANGEREAD
Public Const COLOR_REFL___SWR As Long = COLOR_WAVE___SWR
Public Const COLOR_GRID___SWR As Long = COLOR_DARKSLATEGRAY
Public Const COLOR_BOLD_GRID___SWR As Long = COLOR_GRAY

Public Const COLOR_WAVE__REAL As Long = &H7FFF00        'springgreen
Public Const COLOR_REFL__REAL As Long = COLOR_WAVE__REAL
Public Const COLOR_GRID__REAL As Long = COLOR_DARKSLATEGRAY
Public Const COLOR_BOLD_GRID__REAL As Long = COLOR_GRAY

Public Const COLOR_WAVE__IMAG As Long = &HFFFF00        'aqua
Public Const COLOR_REFL__IMAG As Long = COLOR_WAVE__IMAG
Public Const COLOR_GRID__IMAG As Long = COLOR_DARKSLATEGRAY
Public Const COLOR_BOLD_GRID__IMAG As Long = COLOR_GRAY

Public Const MkrfGHzfkHz$ = "#0.000000000000#"          ' 0.000 001 GHz = 1kHz resolution
'Public Const MkrfMHzfkHz$ = "#0.000000000#"            ' 0.001 MHz     = 1kHz resolution
Public Const MkrfMHzfkHz$ = "#0.000"                    ' 0.001 MHz     = 1kHz resolution

Public Const RSLT_LINE_Y_OFFSET As Long = 0.5
Public Const RSLT_LINE_X_OFFSET As String = "  "

'************************************************************************
' Auto XP[{^
'         ByRef mx As Double   : ől
'         ByRef mn As Double   : ŏl
'         ByRef scl As Scale_t : XP[l
'************************************************************************
Public Sub auto_scale(ByRef mx As Double, ByRef mn As Double, ByRef scl As Scale_t)
    Dim div As Double
    Dim divs As String
    Dim head As String
    Dim rfv As Double

    div = (mx - mn) / 9
    If div < 0.001 Then '=== Does not perform scaling when value is less than 0.001 ===
        div = 0.001
    Else
        div = div * 1000 '<-- Multiply the value by 1000 temporarily.
        divs = CStr(div)
        If CDbl(Mid(divs, 2)) > 0 Then 'When the second and subsequent digits are other than 0.
            divs = CStr(CDbl(divs) - CDbl(Mid(divs, 2))) 'Clear the second and subsequent digits from the beginning to 0.
            divs = (CDbl(Mid(divs, 1, 1)) + 1) & Mid(divs, 2) 'Round-up the first digit.
        End If
        head = Mid(divs, 1, 1) 'Take out the first character.
        If CDbl(head) > 5 Then '--- Convert the value to 1/2/5 step. ---
            head = "10" '        V
        ElseIf CDbl(head) > 2 Then  '        V
            head = "5" '        V
        ElseIf CDbl(head) > 1 Then  '        V
            head = "2" '        V
        End If '        V
        divs = head & Mid(divs, 2)
        div = CSng(divs) / 1000 '<-- Clear the multiplication by 1000.
    End If
    scl.div = div
    rfv = CSng(CLng((mx + mn) / 2 / div)) * div
    scl.ref = rfv + ((scl.pos - 50) * div) / 10

End Sub

Function chg_unit_value(ByRef dt As Double, ByRef unit_dt As Double) As Double
    Dim d As Single

    d = dt
    unit_dt = Unit_s

    If d >= Unit_g Then
        d = dt * Multiple_g
        unit_dt = Unit_g
    ElseIf d >= Unit_mega Then
        d = dt * Multiple_mega
        unit_dt = Unit_mega
    ElseIf d >= Unit_k Then
        d = dt * Multiple_k
        unit_dt = Unit_k
    ElseIf d >= Unit_s Then
        d = dt
        unit_dt = Unit_s
    ElseIf d >= Unit_m Then
        d = dt * Multiple_m
        unit_dt = Unit_m
    ElseIf d >= Unit_u Then
        d = dt * Multiple_u
        unit_dt = Unit_u
    ElseIf d >= Unit_n Then
        d = dt * Multiple_n
        unit_dt = Unit_n
    ElseIf d >= Unit_p Then
        d = dt * Multiple_p
        unit_dt = Unit_p
    ElseIf d >= Unit_f Then
        d = dt * Multiple_f
        unit_dt = Unit_f
    End If

    chg_unit_value = d

End Function

Sub auto_scale2(ByRef mx As Double, ByRef mn As Double, ByRef scl As Scale_t)
    Dim unit_dt As Double
    Dim div As Double
    Dim divs As String
    Dim head As String
    Dim rfv As Double

    div = (mx - mn) / 9
    div = chg_unit_value(div, unit_dt)
    If div < 0.001 Then '=== Does not perform scaling when value is less than 0.001 ===
        div = 0.001
    Else
        div = div * 1000 '<-- Multiply the value by 1000 temporarily.
        divs = CStr(div)
        If CDbl(Mid(divs, 2)) > 0 Then 'When the second and subsequent digits are other than 0.
            divs = CStr(CDbl(divs) - CDbl(Mid(divs, 2))) 'Clear the second and subsequent digits from the beginning to 0.
            divs = (CDbl(Mid(divs, 1, 1)) + 1) & Mid(divs, 2) 'Round-up the first digit.
        End If
        head = Mid(divs, 1, 1) 'Take out the first character.
        If CDbl(head) > 5 Then '--- Convert the value to 1/2/5 step. ---
            head = "10" '        V
        ElseIf CDbl(head) > 2 Then  '        V
            head = "5" '        V
        ElseIf CDbl(head) > 1 Then  '        V
            head = "2" '        V
        End If '        V
        divs = head & Mid(divs, 2)
        div = CSng(divs) / 1000 '<-- Clear the multiplication by 1000.
    End If
    div = div * unit_dt
    scl.div = div
    rfv = CSng(CLng((mx + mn) / 2 / div)) * div
    scl.ref = rfv + ((scl.pos - 50) * div) / 10
End Sub

'***********************************************************************************
' Obh\
'***********************************************************************************
Private Sub grid_display(ByRef pic As PictureBox, GrphRectInf As struct_Rectangular_coordinate)
    Dim i As Integer
    
    With GrphRectInf
        pic.DrawStyle = 0  'Solid line specification
        '----------------------------------
        ' Grid display
        '----------------------------------
        For i = 1 To 9
            If i <> 5 And i <> 10 Then
                pic.PSet (.ViewX + .X_offset, .ViewY * (i + .VYoff) + .Y_offset)
                pic.Line -(.ViewX * 101 + .X_offset, .ViewY * (i + .VYoff) + .Y_offset), .Color_Grid
                pic.PSet (.ViewX * (i * 10 + 1) + .X_offset, .ViewY * .VYoff + .Y_offset)
                pic.Line -(.ViewX * (i * 10 + 1) + .X_offset, .ViewY * (10 + .VYoff) + .Y_offset), .Color_Grid
            End If
        Next i
    
        For i = 0 To 10 Step 5
            pic.PSet (.ViewX + .X_offset, .ViewY * (i + .VYoff) + .Y_offset)
            pic.Line -(.ViewX * 101 + .X_offset, .ViewY * (i + .VYoff) + .Y_offset), .Color_BGrid
            pic.PSet (.ViewX * (i * 10 + 1) + .X_offset, .ViewY * .VYoff + .Y_offset)
            pic.Line -(.ViewX * (i * 10 + 1) + .X_offset, .ViewY * (10 + .VYoff) + .Y_offset), .Color_BGrid
        Next i
    
        pic.Line -(.ViewX * 101 + .X_offset, .ViewY * 10 + .Y_offset), .Color_BGrid ' Because the end point is not displayed.
    End With
    
End Sub

'***********************************************************************************
' t@XE}[J\
'***********************************************************************************
Private Sub ref_mkr_display(ByRef pic As PictureBox, ByRef scl As Scale_t, GrphRectInf As struct_Rectangular_coordinate)
    Dim yy As Single
    
    With GrphRectInf
        '----------------------------------
        ' Reference mark  display
        '----------------------------------
        yy = .ViewY * (10 + .VYoff - scl.pos / 10) + .Y_offset
        pic.PSet (.ViewX * 101 + .X_offset, yy)
        pic.Line -(.ViewX * 103 + .X_offset, yy - .ViewY * 0.15), .Color_RefMkr
        pic.Line -(.ViewX * 103 + .X_offset, yy + .ViewY * 0.15), .Color_RefMkr
        pic.Line -(.ViewX * 101 + .X_offset, yy), .Color_RefMkr
    End With
End Sub

'***********************************************************************************
' XP[͈̓`FbN
'***********************************************************************************
Private Function SclLim(ByVal mx As Single, ByVal mn As Single, ByVal vy As Single, _
                        ByVal dy As Single, ByVal dt As Single) As Single
    Dim hh As Single
    Dim ym As Single
    Dim yn As Single

    '' Add a few dots to the upper and lower scale limits.
    hh = dy * (mx - mn)
    ym = hh * (-0.01)
    yn = hh * 1.01
    SclLim = dy * (mx - dt)
    If ym > SclLim Then
        SclLim = ym
    ElseIf SclLim > yn Then
        SclLim = yn
    End If
    SclLim = vy + SclLim

End Function

'***********************************************************************************
' g`\(W\)
'***********************************************************************************
Private Sub waveform_display(ByRef pic As PictureBox, ByVal lngCh As Long, ByRef scl As Scale_t, _
                ByRef GrphRectInf As struct_Rectangular_coordinate, ByRef Data() As Single)
    Dim Grefv, Gsdiv, Grefp, StepSdiv As Single
    Dim ss As Single
    Dim Gsmax, Gsmin As Single
    Dim DeltY As Single
    Dim x1, y1, x2, y2 As Single
    Dim x1_pre, y1_pre, x2_pre, y2_pre As Single
    Dim i As Integer
    Dim po As Long
    Dim Ydata1 As Single
    
    On Error GoTo ErrLogmagOverflow

    '----------------------------------
    '  waveform
    '----------------------------------
    With GrphRectInf
        Grefv = scl.ref
        Gsdiv = scl.div
        Grefp = scl.pos
        StepSdiv = Gsdiv / 10
        ss = Abs(100 - Grefp)
        Gsmax = Grefv + (ss * StepSdiv)
        Gsmin = Grefv - (Abs(100 - ss) * StepSdiv)
    
        'Calculating 
        ss = Gsmax - Gsmin
        If ss = 0 Then ss = Gsmin
        DeltY = (.ViewY * 10) / ss
        '
        Ydata1 = SclLim(Gsmax, Gsmin, .ViewY * .VYoff + .Y_offset, DeltY, Data(0, lngCh))
        pic.PSet (.ViewX + .X_offset, Ydata1)
        i = 0
        For po = 0 To .points
            Ydata1 = SclLim(Gsmax, Gsmin, .ViewY * .VYoff + .Y_offset, DeltY, Data(i, lngCh))
            pic.Line -(.DeltX * po + .ViewX + .X_offset, Ydata1), .Color_Trace
            i = i + 1
        Next po
    End With
    
ErrLogmagEnd:
    On Error GoTo 0
    Exit Sub

ErrLogmagOverflow:
    MsgBox "Error Data Overflow" + vbCrLf + vbCrLf, vbOKOnly Or vbCritical
    GoTo ErrLogmagEnd

End Sub

'***********************************************************************************
' 
'     ByVal g As Graphics : Ot\ւ̃IuWFNg
'         ByRef points As Integer : |Cg
'         ByRef scl As Scale_t : XP[
'         ByRef p1 As Integer : Box(x1, y) }[J[\ʒu|Cg
'         ByRef p2 As Integer : Box(x2, y) }[J[\ʒu|Cg
'         ByVal Y As Single   : Y
'               Color As Long : ̐F
'***********************************************************************************
Private Sub box_x_display(ByRef pic As PictureBox, ByRef GrphRectInf As struct_Rectangular_coordinate, ByVal points As Integer, _
                    ByRef scl As Scale_t, ByVal p1 As Single, ByVal p2 As Single, ByVal y As Single, _
                    ByVal DeltX As Single, ByVal DeltY As Single, _
                    ByVal Gsmax As Single, ByVal Gsmin As Single, Color As Long)
    Dim yy As Single
    Dim x1, x2 As Single
    
    x1 = DeltX * p1 + GrphRectInf.ViewX + GrphRectInf.X_offset
    x2 = DeltX * p2 + GrphRectInf.ViewX + GrphRectInf.X_offset
    
    yy = SclLim(Gsmax, Gsmin, GrphRectInf.ViewY * GrphRectInf.VYoff, DeltY, y)
    pic.PSet (x1, yy + GrphRectInf.Y_offset)
    pic.Line -(x2, yy + GrphRectInf.Y_offset), Color

End Sub


'***********************************************************************************
' c
'     ByVal g As Graphics : Ot\ւ̃IuWFNg
'         ByRef points As Integer : |Cg
'         ByVal p1_disp As Integer : Box(x1, y) \tO
'         ByVal p2_disp As Integer : Box(x2, y) \tO
'         ByRef p1 As Integer : Box(x1, y) }[J[\ʒu|Cg
'         ByRef p2 As Integer : Box(x2, y) }[J[\ʒu|Cg
'***********************************************************************************
Private Sub box_yy_display(ByVal lngCh As Long, ByRef pic As PictureBox, ByRef GrphRectInf As struct_Rectangular_coordinate, ByVal points As Integer, _
                    ByRef scl As Scale_t, ByRef msi As struct_measInfo, _
                    ByVal DeltX As Single, ByVal DeltY As Single, _
                    ByVal Gsmax As Single, ByVal Gsmin As Single, Color As Long)
    Dim x1, x2 As Single
    Dim Lwy, Upy As Single
    
    With GrphRectInf
        If msi.LwLmtFrqFlg Then
            x1 = x_point_interpolation(lngCh, msi.PLwLmtFrq, msi.LwLmtFrq, BufFrq)
            x1 = DeltX * x1 + .ViewX
            If msi.LwLmtLvlFlg And msi.UpLmtLvlFlg Then
                Lwy = SclLim(Gsmax, Gsmin, .ViewY * .VYoff, DeltY, msi.LwLmtLvl)
                Upy = SclLim(Gsmax, Gsmin, .ViewY * .VYoff, DeltY, msi.UpLmtLvl)
                pic.PSet (x1 + .X_offset, Lwy + .Y_offset)
                pic.Line -(x1 + .X_offset, Upy + .Y_offset), Color
            Else
                pic.PSet (x1 + .X_offset, .ViewY * .VYoff + .Y_offset)
                pic.Line -(x1 + .X_offset, .ViewY * (10 + .VYoff) + .Y_offset), Color
            End If
        End If
        
        If msi.UpLmtFrqFlg Then
            x2 = x_point_interpolation(lngCh, msi.PUpLmtFrq, msi.UpLmtFrq, BufFrq)
            x2 = DeltX * x2 + .ViewX
            If msi.LwLmtLvlFlg And msi.UpLmtLvlFlg Then
                Lwy = SclLim(Gsmax, Gsmin, .ViewY * .VYoff, DeltY, msi.LwLmtLvl)
                Upy = SclLim(Gsmax, Gsmin, .ViewY * .VYoff, DeltY, msi.UpLmtLvl)
                pic.PSet (x2 + .X_offset, Lwy + .Y_offset)
                pic.Line -(x2 + .X_offset, Upy + .Y_offset), Color
            Else
                pic.PSet (x2 + .X_offset, .ViewY * .VYoff + .Y_offset)
                pic.Line -(x2 + .X_offset, .ViewY * (10 + .VYoff) + .Y_offset), Color
            End If
        End If
    End With
End Sub

'***********************************************************************************
' ԏiԁj
'***********************************************************************************
Private Function x_mkr_interpolation(ByVal ActCh As Long, ByRef Rectinf As struct_Rectangular_coordinate, ByVal mp As Long, ByVal mkx As Double, ByRef Refx() As Double) As Single
    Dim xx As Single
    
    With Rectinf
        If mkx <> Refx(mp, ActCh) Then
            If mp <> 0 Then
                If Refx(mp - 1, ActCh) < mkx And mkx < Refx(mp, ActCh) Then mp = mp - 1
            End If
            If Refx(mp + 1, ActCh) - Refx(mp, ActCh) <> 0 Then
                mkx = mp + (mkx - Refx(mp, ActCh)) * ((mp + 1) - mp) / (Refx(mp + 1, ActCh) - Refx(mp, ActCh))
                xx = .DeltX * mkx + .ViewX + .X_offset
            Else
                xx = .DeltX * mp + .ViewX + .X_offset
            End If
        Else
            xx = .DeltX * mp + .ViewX + .X_offset
        End If
    End With
    
    x_mkr_interpolation = xx
End Function

'***********************************************************************************
' ԏiԁj
'***********************************************************************************
Public Function x_point_interpolation(ByVal ActCh As Long, ByVal mp As Long, ByVal mkx As Double, ByRef Refx() As Double) As Single
    Dim xx As Single
    
    If mkx <> Refx(mp, ActCh) Then
        If mp <> 0 Then
            If Refx(mp - 1, ActCh) < mkx And mkx < Refx(mp, ActCh) Then mp = mp - 1
        End If
        If Refx(mp + 1, ActCh) - Refx(mp, ActCh) <> 0 Then
            xx = mp + (mkx - Refx(mp, ActCh)) * ((mp + 1) - mp) / (Refx(mp + 1, ActCh) - Refx(mp, ActCh))
        Else
            xx = mp
        End If
    Else
        xx = mp
    End If
    
    x_point_interpolation = xx
End Function

'***********************************************************************************
' }[J\
'***********************************************************************************
Private Sub grph_mkr_mark_disp(ByRef pic As PictureBox, ByVal xx As Single, ByVal yy As Single, ByVal MkrNo As Long, ByVal Color As Long)
    Dim x As Single
    
    pic.PSet (xx, yy)
    pic.Line (xx, yy)-(xx, yy - 200), Color
    For x = xx To xx - 60 Step -1
        pic.Line (xx, yy)-(x, yy - 150), Color
    Next x
    For x = xx To xx + 60 Step 1
        pic.Line (xx, yy)-(x, yy - 150), Color
    Next x
    Call frmCH.PicBoxMkrDisp(pic, xx - 150, yy - 410, "M" & CStr(MkrNo), 10, Color)  'Marker No. display
End Sub

'***********************************************************************************
' 茋ʕ\
'***********************************************************************************
Public Sub result_display(ByVal lngCh As Long, ByRef pic As PictureBox)

    Dim Y_line As Single
    Dim line_cnt As Integer
    Dim Color As Long
    Dim StrMeasData As String
    Dim MkrNo As Long
    
    Y_line = McrDispLineOf    ' 1 Line Offset
    line_cnt = 1
    
    For MkrNo = 0 To ChInfo(lngCh).MeasSegNum - 1  '荀ڐ
        If MeasData(lngCh, MkrNo).ResJudge = JUDG_FAIL Then
            Color = vbRed
        Else
            Color = vbWhite
        End If
        StrMeasData = MeasData(lngCh, MkrNo).strDispData
        Call frmCH.PicBoxTextDisp(pic, _
                                    ChRsltPosi(lngCh), _
                                    ChInfo(lngCh).MeasSegNum + RSLT_LINE_Y_OFFSET, _
                                    line_cnt, _
                                    StrMeasData & RSLT_LINE_X_OFFSET, _
                                    Color)
        line_cnt = line_cnt + 1
    Next MkrNo
End Sub

'***********************************************************************************
' \ʒuvZ
'***********************************************************************************
Public Sub DispPosiCalc(ByRef pic As PictureBox, ByRef ch_inf As struct_Chinfo)
    Dim trc_i As Long
    Dim x_div As Single
    Dim y_div As Single
    Dim posi As Long

    x_div = 1: y_div = 1
    If ch_inf.argNum < McrArgWind3 Then
        If ch_inf.argNum = McrArgWind2 Then
            x_div = 2
        End If
    Else
        x_div = 2: y_div = 2
    End If
    
    'Calculates size of scale fram
    For trc_i = 0 To ch_inf.trcNum - 1
        
        posi = ch_inf.trc(trc_i).ArgNo
        
        With ch_inf.trc(trc_i).GrphRect
            .points = ch_inf.lngTotP - 1
            .ViewX = pic.ScaleWidth / x_div / 104
            .ViewY = pic.ScaleHeight / y_div / 11
            .VYoff = GRAPH_Y_POSI_OFFSET
            .DeltX = (.ViewX * 100) / .points
            
            If (ch_inf.trc(trc_i).trcFrmt And WAVE_FORMAT_LOGMAG) > 0 Then
                .Color_Grid = COLOR_GRID_LOGMAG
                .Color_BGrid = COLOR_BOLD_GRID_LOGMAG
                .Color_RefMkr = COLOR_REFL_LOGMAG
                .Color_Trace = COLOR_WAVE_LOGMAG
            ElseIf (ch_inf.trc(trc_i).trcFrmt And WAVE_FORMAT____SWR) > 0 Then
                .Color_Grid = COLOR_GRID___SWR
                .Color_BGrid = COLOR_BOLD_GRID___SWR
                .Color_RefMkr = COLOR_REFL___SWR
                .Color_Trace = COLOR_WAVE___SWR
            End If
            
            .X_offset = 0: .Y_offset = 0
            If posi = McrArgPosi2 Then
                .X_offset = pic.ScaleWidth / x_div
            ElseIf posi = McrArgPosi3 Then
                .Y_offset = pic.ScaleHeight / y_div
            ElseIf posi = McrArgPosi4 Then
                .X_offset = pic.ScaleWidth / x_div: .Y_offset = pic.ScaleHeight / y_div
            End If
        End With
        
        With ch_inf.trc(trc_i).GrphPolar
            .points = ch_inf.lngTotP - 1
            .ViewPS_X = pic.ScaleWidth / x_div / 12
            .ViewPS_Y = pic.ScaleHeight / y_div / 12
            .HanY = .ViewPS_Y * 5: .HanX = .HanY
            .CenX = .ViewPS_X * 6 - CENTER_OFFSET
            .CenY = .ViewPS_Y * 6 * GRAPH_Y_RATIO
            .Color_Grid = COLOR_GRID_SMITH
            .Color_BGrid = COLOR_BOLD_GRID_SMITH
            .Color_Trace = COLOR_WAVE_SMITH
            
            .X_Cen_offset = 0: .Y_Cen_offset = 0
            If posi = McrArgPosi2 Then
                .X_Cen_offset = pic.ScaleWidth / x_div
            ElseIf posi = McrArgPosi3 Then
                .Y_Cen_offset = pic.ScaleHeight / y_div
            ElseIf posi = McrArgPosi4 Then
                .X_Cen_offset = pic.ScaleWidth / x_div: .Y_Cen_offset = pic.ScaleHeight / y_div
            End If
        End With
    
    Next trc_i
    
End Sub

'***********************************************************************************
' ~bgEC & }[J \
'***********************************************************************************
Private Sub LmtLineMkrDisp(ByRef pic As PictureBox, ByVal lngCh As Long, ByVal TrcNo As Long)
    Dim scl As Scale_t
    Dim Grefv, Gsdiv, Grefp, StepSdiv As Single
    Dim DeltX As Single
    Dim DeltY As Single
    Dim x_st As Single
    Dim x_sp As Single
    Dim xx As Single
    Dim yy As Single
    Dim i As Integer
    Dim ss, Gsmax, Gsmin As Single
    Dim pt As Long
    Dim lwfrqdsp As Integer
    Dim upfrqdsp As Integer
    Dim strMsrTrcFmt As String
    Dim Color As Long
    Dim mp As Long
    Dim dt As Single

    For i = 0 To ChInfo(lngCh).MeasSegNum - 1
        pt = ChInfo(lngCh).lngTotP - 1
        With MeasInfo(lngCh, i)
            If .RefFmtNo - 1 = TrcNo Then
                If (ChInfo(lngCh).trc(.RefFmtNo - 1).trcFrmt And WAVE_FORMAT_LOGMAG) > 0 Then
                    scl = ChInfo(lngCh).trc(.RefFmtNo - 1).trcFmtScale.Mscl
                ElseIf (ChInfo(lngCh).trc(.RefFmtNo - 1).trcFrmt And WAVE_FORMAT____SWR) > 0 Then
                    scl = ChInfo(lngCh).trc(.RefFmtNo - 1).trcFmtScale.SWRscl
                End If
                
                Grefv = scl.ref
                Gsdiv = scl.div
                Grefp = scl.pos
                StepSdiv = Gsdiv / 10
                ss = Abs(100 - Grefp)
                Gsmax = Grefv + (ss * StepSdiv)
                Gsmin = Grefv - (Abs(100 - ss) * StepSdiv)
                ss = Gsmax - Gsmin
                If ss = 0 Then ss = Gsmin
                DeltX = (ChInfo(lngCh).trc(.RefFmtNo - 1).GrphRect.ViewX * 100) / pt
                DeltY = (ChInfo(lngCh).trc(.RefFmtNo - 1).GrphRect.ViewY * 10) / ss
                
'*********************
'* Limit Line Display
'*********************
                If .LmtDspFlg = BIS_ON And .RefFmtNo > 0 Then
                    If .LwLmtLvlFlg = BIS_ON Or .UpLmtLvlFlg = BIS_ON Then
                        If .MeasType <> McrMeasPWRVAL Then
                            x_st = x_point_interpolation(lngCh, .PStart, .Start, BufFrq)
                            x_sp = x_point_interpolation(lngCh, .PStop, .Stop, BufFrq)
                        Else
                            x_st = x_point_interpolation(lngCh, .PStart, .Start, BufLvl)
                            x_sp = x_st
                        End If
                        If .LwLmtLvlFlg = BIS_ON Then
                            Call box_x_display(pic, ChInfo(lngCh).trc(.RefFmtNo - 1).GrphRect, pt, scl, x_st, x_sp, .LwLmtLvl, DeltX, DeltY, Gsmax, Gsmin, vbRed)
                        End If
                        If .UpLmtLvlFlg = BIS_ON Then
                            Call box_x_display(pic, ChInfo(lngCh).trc(.RefFmtNo - 1).GrphRect, pt, scl, x_st, x_sp, .UpLmtLvl, DeltX, DeltY, Gsmax, Gsmin, vbRed)
                        End If
                    End If
                    If .LwLmtFrqFlg Or .UpLmtFrqFlg Then
                        With ChInfo(lngCh).trc(.RefFmtNo - 1)
                            Call box_yy_display(lngCh, pic, .GrphRect, pt, scl, MeasInfo(lngCh, i), DeltX, DeltY, Gsmax, Gsmin, vbRed)
                        End With
                    End If
                End If
            
'*****************
'* Marker Display
'*****************
                If MeasData(lngCh, i).ResJudge = JUDG_FAIL Then
                    Color = vbRed
                Else
                    Color = vbCyan
                End If
                mp = MeasData(lngCh, i).freqp1
                If mp >= 0 And (ChInfo(lngCh).trc(.RefFmtNo - 1).trcFrmt And MeasData(lngCh, i).ResTrcFmt) > 0 Then
                    dt = MeasData(lngCh, i).ResData2
                    With ChInfo(lngCh).trc(.RefFmtNo - 1)
                        If MeasData(lngCh, i).ResType = McrFreq Then
                            xx = x_mkr_interpolation(lngCh, .GrphRect, mp, MeasData(lngCh, i).ResData1, BufFrq)
                        Else
                            xx = x_mkr_interpolation(lngCh, .GrphRect, mp, MeasData(lngCh, i).ResData1, BufLvl)
                        End If
                        yy = SclLim(Gsmax, Gsmin, .GrphRect.ViewY * .GrphRect.VYoff + .GrphRect.Y_offset, DeltY, dt)
                        Call grph_mkr_mark_disp(pic, xx, yy, MeasData(lngCh, i).DspMkrNo, Color)  '}[J\
                    End With
                End If
            End If
        End With
    Next i

End Sub

'***********************************************************************************
' Arrow marker display (POLAR & Smith)
'    Sub PolarMkrDisp()
'    Argument ByRef pic As PictureBox : Object of the graph display
'         ByVal lngCh As Long : Measurment CH No.
'         ByVal TrcNo As Long : Measurment trace No.
'***********************************************************************************
Public Sub PolarMkrDisp(ByRef pic As PictureBox, ByVal lngCh As Long, ByVal TrcNo As Long)
    Dim xx As Single
    Dim yy As Single
    Dim StrMeasData As String
    Dim k As Integer
    Dim Y_line As Single
    Dim Color As Long
    Dim i As Integer
    Dim mp As Integer
    Dim mkr_frq As Double
    Dim dt As Single
    '
    Y_line = 150    ' 1 Line Offset
'*****************
'* Marker Display
'*****************
    For i = 0 To ChInfo(lngCh).MeasSegNum - 1
        With MeasInfo(lngCh, i)
            If .RefFmtNo - 1 = TrcNo Then
                If MeasData(lngCh, i).ResJudge = JUDG_FAIL Then
                    Color = vbRed
                Else
                    Color = vbCyan
                End If
                    
                mp = MeasData(lngCh, i).freqp1
                If mp >= 0 And (ChInfo(lngCh).trc(.RefFmtNo - 1).trcFrmt And MeasData(lngCh, i).ResTrcFmt) > 0 Then
                    dt = MeasData(lngCh, i).ResData2
                    With ChInfo(lngCh).trc(.RefFmtNo - 1).GrphPolar
                        If MeasData(lngCh, i).ResType = McrFreq Then
                            xx = SclLimP(.CenX + .X_Cen_offset, .HanX, BufReal(mp, lngCh))
                            yy = SclLimP(.CenY + .Y_Cen_offset, -.HanY, BufImag(mp, lngCh))
                        Else
                            If mp <> 0 Then
                                If BufFrq(mp - 1, lngCh) < mkr_frq And mkr_frq < BufFrq(mp, lngCh) Then
                                    mp = mp - 1
                                ElseIf BufFrq(mp, lngCh) < mkr_frq And mkr_frq < BufFrq(mp - 1, lngCh) Then
                                    mp = mp - 1
                                End If
                            End If
                            If BufFrq(mp + 1, lngCh) = BufFrq(mp, lngCh) Then
                                yy = BufImag(mp, lngCh) + (BufImag(mp + 1, lngCh) - BufImag(mp, lngCh))
                                xx = BufReal(mp, lngCh) + (BufReal(mp + 1, lngCh) - BufReal(mp, lngCh))
                            Else
                                yy = BufImag(mp, lngCh) + (mkr_frq - BufFrq(mp, lngCh)) * ((BufImag(mp + 1, lngCh) - BufImag(mp, lngCh)) / (BufFrq(mp + 1, lngCh) - BufFrq(mp, lngCh)))
                                xx = BufReal(mp, lngCh) + (mkr_frq - BufFrq(mp, lngCh)) * (BufReal(mp + 1, lngCh) - BufReal(mp, lngCh)) / (BufFrq(mp + 1, lngCh) - BufFrq(mp, lngCh))
                            End If
                            xx = SclLimP(.CenX + .X_Cen_offset, .HanX, xx)
                            yy = SclLimP(.CenY + .Y_Cen_offset, -.HanY, yy)
                        End If
                    
                        Call grph_mkr_mark_disp(pic, xx, yy, MeasData(lngCh, i).DspMkrNo, Color)  'Marker display
                    End With
                End If
            End If
        End With
    Next i
   
End Sub

'***********************************************************************************
' Obh, Ref Mkrt, g`\
'***********************************************************************************
Public Sub GridRefMkrWaveDisp(ByRef pic As PictureBox, ByVal lngCh As Long)
    Dim trc_i As Long
    
    Call DispPosiCalc(pic, ChInfo(lngCh))
    For trc_i = 0 To ChInfo(lngCh).trcNum - 1
        With ChInfo(lngCh).trc(trc_i)
            If (.trcFrmt And (WAVE_FORMAT_LOGMAG Or WAVE_FORMAT__DELAY Or WAVE_FORMAT____SWR Or WAVE_FORMAT___REAL Or WAVE_FORMAT___IMAG)) <> 0 Then
                Call grid_display(pic, .GrphRect)                                       '*** Grid Display ***
                Call ref_mkr_display(pic, .trcFmtScale.Mscl, .GrphRect)                 '*** Ref Marker Display ***
                If (.trcFrmt And WAVE_FORMAT_LOGMAG) > 0 Then
                    Call waveform_display(pic, lngCh, .trcFmtScale.Mscl, .GrphRect, BufLgm) '*** LogMag Wave Display ***
                ElseIf (.trcFrmt And WAVE_FORMAT____SWR) > 0 Then
                    Call waveform_display(pic, lngCh, .trcFmtScale.SWRscl, .GrphRect, BufSwr)  '*** SWR Wave Display ***
                End If
                Call LmtLineMkrDisp(pic, lngCh, trc_i)                                         '*** Limit Line & Marker Display ***
            ElseIf .trcFrmt And WAVE_FORMAT__POLAR Then
                Call gridP_display(pic, .GrphPolar)
                Call waveformP_display(pic, lngCh, .GrphPolar, COLOR_WAVE_POLAR, BufReal, BufImag)
            ElseIf .trcFrmt And WAVE_FORMAT__SMITH Then
                Call gridS_display(pic, .GrphPolar)
                Call waveformP_display(pic, lngCh, .GrphPolar, COLOR_WAVE_SMITH, BufReal, BufImag)
                Call PolarMkrDisp(pic, lngCh, trc_i)
            End If
        End With
    Next trc_i

End Sub

    
'***********************************************************************************
' g`\
'***********************************************************************************
Public Sub draw_graph(ByVal lngCh As Long, ByRef pic As PictureBox)
    
    If DuringBootUp = True Then Exit Sub
    pic.Cls
    Call GridRefMkrWaveDisp(pic, lngCh)     '*** Grid # display ***
           
End Sub


'***********************************************************************************
' Marker display conversion (POLAR & Smith)
'    Function SclLimP() As Single
'    Argument ByVal c As Single : Reference point
'         ByRef R As Single : Ratio in the drawing direction
'         ByRef dt As Single : Display data
'
'    Return value : Display position
'***********************************************************************************
Public Function SclLimP(ByRef c As Single, ByRef R As Single, ByRef dt As Single) As Single
    Dim tmp As Single

    tmp = dt
    If 1 < tmp Then tmp = 1
    If tmp < -1 Then tmp = -1
    SclLimP = c + (tmp * R)

End Function

'***********************************************************************************
' Waveform display (POLAR)
'    Sub waveformP_display()
'    Argument ByRef pic As PictureBox : Object of the graph display
'         ByRef ViewX As Single : Display area (X)
'         ByRef ViewY As Single : Display area (Y)
'         ByRef VYoff As Single : Offset in Y direction
'         ByRef Scale As Scale_t : Scale value displayed
'         ByRef points As Integer : Number of measurement points
'         ByVal Color As Long    : Waveform color
'         ByRef real() As Single : Array data of Real value
'         ByRef imag() As Single : Array data of Imag value
'***********************************************************************************
Private Sub waveformP_display(ByRef pic As PictureBox, ByVal lngCh As Long, GrphCircle As struct_PolarCoordinates, _
                                ByVal Color As Long, ByRef real() As Single, ByRef imag() As Single)
    Dim Ydata1, Xdata1 As Single
    Dim po As Integer
    
    On Error GoTo ErrReImOverflow

    '----------------------------------
    ' POLAR waveform display
    '----------------------------------
    With GrphCircle
        Xdata1 = SclLimP(.CenX + .X_Cen_offset, .HanX, real(0, lngCh))
        Ydata1 = SclLimP(.CenY + .Y_Cen_offset, -.HanY, imag(0, lngCh))
    
        pic.PSet (Xdata1, Ydata1)
    
        For po = 0 To .points
          Xdata1 = SclLimP(.CenX + .X_Cen_offset, .HanX, real(po, lngCh))
          Ydata1 = SclLimP(.CenY + .Y_Cen_offset, -.HanY, imag(po, lngCh))
          pic.Line -(Xdata1, Ydata1), Color
        Next po
    
ErrReImEnd:
    End With
    On Error GoTo 0
    Exit Sub

ErrReImOverflow:
    MsgBox "Error Re/Im Data Overflow" + vbCrLf + vbCrLf, vbOKOnly Or vbCritical
    GoTo ErrReImEnd

End Sub


'***********************************************************************************
' Grid display (POLAR)
'    Sub gridP_display()
'    Argument ByVal g As Graphics : Object of the graph display
'         ByRef CenX As Single : Central coordinate for display area (X)
'         ByRef CenY As Single : Central coordinate for display area (Y)
'         ByRef HanX As Single : X direction (radius of circle)
'         ByRef HanY As Single : Y direction (radius of circle)
'         ByVal Color1 As Long    : Grid color
'         ByVal Color2 As Long    : Grid color
'***********************************************************************************
Private Sub gridP_display(ByRef pic As PictureBox, ByRef GrphCircle As struct_PolarCoordinates)
    Dim x As Single
    Dim y As Single
    
    pic.DrawStyle = 0  'Solid line specification

    '----------------------------------
    ' Grid display
    '----------------------------------
    With GrphCircle
        x = .CenX + .X_Cen_offset
        y = .CenY + .Y_Cen_offset
        
        pic.PSet (x - .HanX, y)
        pic.Line -(x + .HanX, y), .Color_Grid
        pic.PSet (x, y - .HanY)
        pic.Line -(x, y + .HanY), .Color_Grid
        pic.Circle (x, y), .HanY, .Color_Grid
    
        pic.Circle (x, y), .HanY * 0.2, .Color_BGrid
        pic.Circle (x, y), .HanY * 0.4, .Color_BGrid
        pic.Circle (x, y), .HanY * 0.6, .Color_BGrid
        pic.Circle (x, y), .HanY * 0.8, .Color_BGrid
    End With
    
End Sub

'**********************************************
Private Sub draw_circle_grid(ByRef pic As PictureBox, ByRef pt As Long, ByRef GrphCircle As struct_PolarCoordinates, _
                        ByRef Color() As Long)
    
    Dim v As Single
    Dim h As Single
    
    v = 1: h = 1
    'Calculates size of scale frame
    With GrphCircle
        .points = pt - 1
        .ViewPS_X = pic.ScaleWidth / h / 12
        .ViewPS_Y = pic.ScaleHeight / v / 12
        .HanY = .ViewPS_Y * 5: .HanX = .HanY
        .CenX = .ViewPS_X * 6 - CENTER_OFFSET
        .CenY = .ViewPS_Y * 6 * GRAPH_Y_RATIO
        .Color_Grid = COLOR_BOLD_GRID_SMITH 'COLOR_GRID_SMITH 'Color(GRID_NORMAL)
        .Color_BGrid = COLOR_GRID_SMITH 'COLOR_BOLD_GRID_SMITH 'Color(GRID_BOLD)
    End With
    

End Sub

Private Sub draw_circle_Pgrid(ByRef pic As PictureBox, ByRef pt As Long, ByRef GrphCircle As struct_PolarCoordinates, _
                        ByRef Color() As Long)
                        
    Call draw_circle_grid(pic, pt, GrphCircle, Color)
    '----------------------------------
    ' Circle grid display
    '----------------------------------
    Call gridP_display(pic, GrphCircle)
                        
End Sub

Private Sub draw_circle_Sgrid(ByRef pic As PictureBox, ByRef pt As Long, ByRef GrphCircle As struct_PolarCoordinates, _
                        ByRef Color() As Long)
                        
    Call draw_circle_grid(pic, pt, GrphCircle, Color)
    '----------------------------------
    ' Circle grid display
    '----------------------------------
    Call gridS_display(pic, GrphCircle)
                        
End Sub

'************************************************************************
' Waveform and marker display (POLAR)
'    Sub draw_waveP_Mem()
'    Argument ByRef pic As System.Windows.Forms.PictureBox :
'         ByRef real() As Single : Array data of Real value
'         ByRef imag() As Single : Array data of Imag value
'         ByRef real_Pre() As Single : For the previous data to draw waveforms (Real value).
'         ByRef imag_Pre() As Single : For the previous data to draw waveforms (Imag value).
'         ByRef pt As Integer : Number of measurement points
'         ByRef mk As Short F Marker drawing flag
'         ByRef mp As Short F Marker position (point value)
'         ByRef mp_Pre As Short F Previous marker position (point value)
'************************************************************************
Sub draw_waveP(ByVal lngCh As Long, ByRef pic As PictureBox, _
                ByRef real() As Single, ByRef imag() As Single, _
                ByRef pt As Long, _
                ByRef mk As Integer)
    Dim GrphCircle As struct_PolarCoordinates

    pic.DrawStyle = 0  'Solid line specification

    pic.Cls
    '----------------------------------
    ' Grid display
    '----------------------------------
    Call draw_circle_Pgrid(pic, pt, GrphCircle, GrdClrPolar)

    '----------------------------------
    ' POLAR waveform display
    '----------------------------------
    Call waveformP_display(pic, lngCh, GrphCircle, COLOR_WAVE_POLAR, real, imag)
    
End Sub

'***********************************************************************************
' Grid display (Smith)
'    Sub gridS_display()
'    Argument ByVal g As Graphics : Object of the graph display
'         ByRef CenX As Single : Display area central coordinate (X)
'         ByRef CenY As Single : Display area central coordinate (Y)
'         ByRef R As Single : Radius (R) of circle (circumference) drawing the grid
'         ByVal Color1 As Long    : Grid Horizontal Reactance axis color
'         ByVal Color2 As Long    : Grid Inner circle color
'***********************************************************************************
Private Sub gridS_display(ByRef pic As PictureBox, ByRef GrphCircle As struct_PolarCoordinates)
    Dim x1, y1, x2, y2 As Single
    Dim Cen_x, Cen_y As Single
    Dim i As Integer
    Dim grid_circle_r(5) As Single  'Scale value of resistance
    Dim grid_circle_x(5) As Single  'Scale value of reactance
    Dim grid_circle_st(5) As Single 'Start angle of reactance arc
    Dim grid_circle_sp(5) As Single 'End angle of reactance arc

    grid_circle_r(0) = 0.2: grid_circle_r(1) = 0.5: grid_circle_r(2) = 1: grid_circle_r(3) = 2: grid_circle_r(4) = 5 'Scale value of resistance
    grid_circle_x(0) = 0.2: grid_circle_x(1) = 0.5: grid_circle_x(2) = 1: grid_circle_x(3) = 2: grid_circle_x(4) = 5 'cale value of reactance
    grid_circle_st(0) = 90#: grid_circle_st(1) = 90#: grid_circle_st(2) = 90#: grid_circle_st(3) = 90#: grid_circle_st(4) = 90# 'Start angle of reactance arc
    grid_circle_sp(0) = 22.6198654: grid_circle_sp(1) = 53.13008:  grid_circle_sp(2) = 89.7: grid_circle_sp(3) = 126.869845: grid_circle_sp(4) = 157.379975 'End angle of reactance arc
    
    pic.DrawStyle = 0  'Solid line specification

    '----------------------------------
    ' Grid display
    '----------------------------------
    'Horizontal axis
    With GrphCircle
        Cen_x = .CenX + .X_Cen_offset
        Cen_y = .CenY + .Y_Cen_offset
        pic.PSet (Cen_x - .HanX, Cen_y)
        pic.Line -(Cen_x + .HanX, Cen_y), .Color_BGrid
        pic.PSet (Cen_x, Cen_y)
        pic.Circle (Cen_x, Cen_y), .HanX, .Color_BGrid
        
        'Inner circle (resistance)
        For i = 0 To 4
            x2 = .HanX * (1 / (1 + grid_circle_r(i)))
            y2 = x2
            x1 = Cen_x + .HanX - x2
            y1 = Cen_y - y2 * 0.5
            pic.Circle (x1, Cen_y), x2, .Color_Grid
        Next
        
        'Reactance
        For i = 0 To 4
            x2 = .HanX * (1 / grid_circle_x(i))
            y2 = x2
            y1 = Cen_y - y2
            pic.Circle (Cen_x + .HanX, y1), x2, .Color_BGrid, (270 - grid_circle_sp(i)) * pi / 180, 270 * pi / 180
    
            y1 = Cen_y + y2
            pic.Circle (Cen_x + .HanX, y1), x2, .Color_BGrid, 90 * pi / 180, (90 + grid_circle_sp(i)) * pi / 180
        Next
        
    End With
    
End Sub

'************************************************************************
' Waveform and marker display (Smith)
'    Sub draw_waveS()
'    Argument ByRef pic As System.Windows.Forms.PictureBox :
'         ByRef real() As Single : Array data of Real value
'         ByRef imag() As Single : Array data of Imag value
'         ByRef real_Pre() As Single : For the previous data to draw waveforms (Real value).
'         ByRef imag_Pre() As Single : For the previous data to draw waveforms (Imag value).
'         ByRef pt As Integer : Number of measurement points
'         ByRef mk As Short F Marker drawing flag
'************************************************************************
Sub draw_waveS(ByVal lngCh As Long, ByRef pic As PictureBox, _
                ByRef real() As Single, ByRef imag() As Single, _
                ByVal pt As Long, _
                ByVal mk As Integer)
    Dim GrphCircle As struct_PolarCoordinates

    pic.DrawStyle = 0  'Solid line specification

    pic.Cls
    '----------------------------------
    ' Grid display
    '----------------------------------
    Call draw_circle_Sgrid(pic, pt, GrphCircle, GrdClrSmith)

    '----------------------------------
    ' Smith waveform display
    '----------------------------------
    Call waveformP_display(pic, lngCh, GrphCircle, COLOR_WAVE_SMITH, real, imag)

End Sub

